Import-Module Microsoft.Graph.DeviceManagement

####################################################
<# region Authentication
To authenticate, you'll use the Microsoft Graph PowerShell SDK. If you haven't already installed the SDK, see this guide:
https://learn.microsoft.com/en-us/powershell/microsoftgraph/installation?view=graph-powershell-1.0

The PowerShell SDK supports two types of authentication: delegated access, and app-only access.

For details on using delegated access, see this guide here:
https://learn.microsoft.com/powershell/microsoftgraph/get-started?view=graph-powershell-1.0

For details on using app-only access for unattended scenarios, see Use app-only authentication with the Microsoft Graph PowerShell SDK:
https://learn.microsoft.com/powershell/microsoftgraph/app-only?view=graph-powershell-1.0&tabs=azure-portal

#>
#endregion

####################################################

$windows = @"

{
    "@odata.type":  "#microsoft.graph.windows10CustomConfiguration",
    "DisplayName":  "DoD Mozilla Firefox STIG v6r7 Custom Profile",
    "omaSettings":  [
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Allow only TLS 1.2 or above",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox/SSLVersionMin",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e \u003cdata id = \"SSLVersion\" value = \"tls1.2\"/\u003e",
                            "displayName":  "FFOX-00-000002"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Configured to not automatically update installed add-ons and plugins",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~Extensions/ExtensionUpdate",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "FFOX-00-000005"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Configured to disable form fill assistance",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox/DisableFormHistory",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "FFOX-00-000007"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Configured to not use a password store with or without a master password",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox/PasswordManagerEnabled",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "FFOX-00-000008"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Configured to block popup windows",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~Popups/PopupBlocking_Default",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "FFOX-00-000009"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Configured to disable the installation of extensions",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~Addons/InstallAddonsPermission_Default",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "FFOX-00-000013"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Background submission of information to Mozilla must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox/DisableTelemetry",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "FFOX-00-000014"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Development tools must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox/DisableDeveloperTools",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "FFOX-00-000015"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Configured to not delete cache data upon shutdown",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~SanitizeOnShutdown/A_SanitizeOnShutdown_Cache",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "FFOX-00-000017 Cache"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Prevent the user from quickly deleting data",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox/DisableForgetButton",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "FFOX-00-000018"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Private browsing must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox/DisablePrivateBrowsing",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "FFOX-00-000019"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Search suggestions must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~Search/SearchSuggestEnabled",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "FFOX-00-000020"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Autoplay must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~Permissions~Autoplay/Autoplay_Default",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e\u003cdata id=\"Autoplay_Default\" value=\"block-audio-video\"/\u003e",
                            "displayName":  "FFOX-00-000021"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Network Prediction must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox/NetworkPrediction",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "FFOX-00-000022"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Fingerprinting protection must be enabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~TrackingProtection/C_TrackingProtection_Fingerprinting",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "FFOX-00-000023"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Cryptomining protection must be enabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~TrackingProtection/B_TrackingProtection_Cryptomining",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "FFOX-00-000024"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Deprecated ciphers must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~DisabledCiphers/DisabledCiphers_TLS_RSA_WITH_3DES_EDE_CBC_SHA",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "FFOX-00-000027"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Firefox must not recommend extensions as the user is using the browser",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~UserMessaging/UserMessaging_ExtensionRecommendations",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "FFOX-00-000028"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Configured so that DNS over HTTPS is disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~DNSOverHTTPS/DNSOverHTTPS_Enabled",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "FFOX-00-000033"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Firefox accounts must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox/DisableFirefoxAccounts",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "FFOX-00-000034"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Feedback reporting must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox/DisableFeedbackCommands",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "FFOX-00-000036"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Encrypted media extensions must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~EncryptedMediaExtensions/EncryptedMediaExtensions_Locked",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "FFOX-00-000037 Lock Encrypted Media"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Encrypted media extensions must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~EncryptedMediaExtensions/EncryptedMediaExtensions_Enabled",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "FFOX-00-000037 Enable Encrypted Media"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Configures multiple Preference STIG requirements",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox/Preferences",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e\n\u003cdata id=\"JSON\" value=\u0027\n{     \n     \"security.default_personal_cert\": {\n     \"Value\": \"Ask Every Time\",\n     \"Status\": \"locked\"\n     },\n     \"browser.search.update\": {\n      \"Value\": false,\n      \"Status\": \"locked\"\n      },\n      \"dom.disable_window_move_resize\": {\n       \"Value\": true,\n       \"Status\": \"locked\"\n       },\n       \"dom.disable_window_flip\": {\n       \"Value\": true,\n       \"Status\": \"locked\"\n       },\n       \"browser.contentblocking.category\": {\n       \"Value\": \"strict\",\n       \"Status\": \"locked\"\n       },\n       \"extensions.htmlaboutaddons.recommendations.enabled\": {\n       \"Value\": false,\n       \"Status\": \"locked\"\n       }\n}\u0027/\u003e",
                            "displayName":  "FFOX-00-000003_4_10_11_25_26"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Configure multiple Firefox home customizations",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox/CustomizeFirefoxHome",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e\n\u003cdata id=\"FirefoxHome_Search\"  value=\"false\"/\u003e\n\u003cdata id=\"FirefoxHome_TopSites\"  value=\"false\"/\u003e\n\u003cdata id=\"FirefoxHome_SponsoredTopSites\"  value=\"false\"/\u003e\n\u003cdata id=\"FirefoxHome_Highlights\"  value=\"false\"/\u003e\n\u003cdata id=\"FirefoxHome_Pocket\"  value=\"false\"/\u003e\n\u003cdata id=\"FirefoxHome_SponsoredPocket\"  value=\"false\"/\u003e\n\u003cdata id=\"FirefoxHome_Snippets\"  value=\"false\"/\u003e\n\u003cdata id=\"FirefoxHome_Locked\"  value=\"true\"/\u003e",
                            "displayName":  "FFOX-00-000029"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Install DoD root certificates",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~Certificates/Certificates_ImportEnterpriseRoots",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "FFOX-00-000016"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Pocket must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox/DisablePocket",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "FFOX-00-000038"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Firefox Studies must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox/DisableFirefoxStudies",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "FFOX-00-000039"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Configured to not delete cookies data upon shutdown",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~SanitizeOnShutdown/B_SanitizeOnShutdown_Cookies",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "FFOX-00-000017 Cookies"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Configured to not delete download data upon shutdown",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~SanitizeOnShutdown/C_SanitizeOnShutdown_Downloads",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "FFOX-00-000017 Downloads"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Configured to not delete FormData data upon shutdown",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~SanitizeOnShutdown/D_SanitizeOnShutdown_FormData",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "FFOX-00-000017 FormData"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Configured to not delete sessions data upon shutdown",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~SanitizeOnShutdown/F_SanitizeOnShutdown_Sessions",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "FFOX-00-000017 Sessions"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Configured to not delete history data upon shutdown",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~SanitizeOnShutdown/E_SanitizeOnShutdown_History",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "FFOX-00-000017 History"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Configured to not delete offlineapps data upon shutdown",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~SanitizeOnShutdown/H_SanitizeOnShutdown_OfflineApps",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "FFOX-00-000017 OfflineApps"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Configured to not delete sitesettings data upon shutdown",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~SanitizeOnShutdown/G_SanitizeOnShutdown_SiteSettings",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "FFOX-00-000017 SiteSettings"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Configured to lock data upon shutdown",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Firefox~Policy~firefox~SanitizeOnShutdown/I_SanitizeOnShutdown_Locked",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "FFOX-00-000017 Locked"
                        }
                                        
                    ]

}

"@

####################################################

New-MgDeviceManagementDeviceConfiguration -BodyParameter $Windows